onmessage = (e) => {
    
    importScripts('./lame.min.js');
    let maxSamples = 1152;
      let wav = new lamejs.WavHeader.readHeader(new DataView(e.data.arrayBuffer));
            if (!wav) {
              return;
            }

            var dataView = new Int16Array(e.data.arrayBuffer, wav.dataOffset, wav.dataLen / 2);
            let samplesLeft = wav.channels === 1 ? dataView : new Int16Array(wav.dataLen / (2 * wav.channels));
            let samplesRight = wav.channels === 2 ? new Int16Array(wav.dataLen / (2 * wav.channels)) : undefined;
            if (wav.channels > 1) {
              for (var i = 0; i < samplesLeft.length; i++) {
                samplesLeft[i] = dataView[i * 2];
                samplesRight[i] = dataView[i * 2 + 1];
              }
            }

            let mp3Encoder = new lamejs.Mp3Encoder(wav.channels, wav.sampleRate, 128);

            var remaining = samplesLeft.length;
            let mp3Data= [];
            for (var i = 0; remaining >= maxSamples; i += maxSamples) {
              var left = samplesLeft.subarray(i, i + maxSamples);
              var right;
              if (samplesRight) {
                right = samplesRight.subarray(i, i + maxSamples);
              }
              var mp3buf = mp3Encoder.encodeBuffer(left, right);
              mp3Data.push(new Int8Array(mp3buf));
              remaining -= maxSamples;
            }

            var blob = new Blob(mp3Data, {type: 'audio/mp3'});
            postMessage(blob);
}