(window["webpackJsonp"]=window["webpackJsonp"]||[]).push([["2d209b8e"],{a9ee:function(e,t,i){"use strict";(function(i,n){var o,a;
/**
 * {@link https://github.com/muaz-khan/RecordRTC|RecordRTC} is a WebRTC JavaScript library for audio/video as well as screen activity recording. It supports Chrome, Firefox, Opera, Android, and Microsoft Edge. Platforms: Linux, Mac and Windows. 
 * @summary Record audio, video or screen inside the browser.
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://MuazKhan.com|Muaz Khan}
 * @typedef RecordRTC
 * @class
 * @example
 * var recorder = RecordRTC(mediaStream or [arrayOfMediaStream], {
 *     type: 'video', // audio or video or gif or canvas
 *     recorderType: MediaStreamRecorder || CanvasRecorder || StereoAudioRecorder || Etc
 * });
 * recorder.startRecording();
 * @see For further information:
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 * @param {MediaStream} mediaStream - Single media-stream object, array of media-streams, html-canvas-element, etc.
 * @param {object} config - {type:"video", recorderType: MediaStreamRecorder, disableLogs: true, numberOfAudioChannels: 1, bufferSize: 0, sampleRate: 0, desiredSampRate: 16000, video: HTMLVideoElement, etc.}
 */
function r(e,t){if(!e)throw"First parameter is required.";t=t||{type:"video"},t=new d(e,t);var i=this;function n(n){return t.disableLogs,n&&(t=new d(e,n)),t.disableLogs,g?(g.clearRecordedData(),g.record(),m("recording"),i.recordingDuration&&h(),i):(o(function(){i.recordingDuration&&h()}),i)}function o(i){i&&(t.initCallback=function(){i(),i=t.initCallback=null});var n=new s(e,t);g=new n(e,t),g.record(),m("recording"),t.disableLogs}function a(e){if(e=e||function(){},g){if("paused"===i.state)return i.resumeRecording(),void setTimeout(function(){a(e)},1);"recording"!==i.state&&t.disableLogs,t.disableLogs,"gif"!==t.type?g.stop(n):(g.stop(),n()),m("stopped")}else v();function n(n){if(g){Object.keys(g).forEach(function(e){"function"!==typeof g[e]&&(i[e]=g[e])});var o=g.blob;if(!o){if(!n)throw"Recording failed.";g.blob=o=n}if(o&&t.disableLogs,e){var a;try{a=p.createObjectURL(o)}catch(e){}"function"===typeof e.call?e.call(i,a):e(a)}t.autoWriteToDisk&&l(function(e){var i={};i[t.type+"Blob"]=e,I.Store(i)})}else"function"===typeof e.call?e.call(i,""):e("")}}function u(){g?"recording"===i.state?(m("paused"),g.pause(),t.disableLogs):t.disableLogs:v()}function c(){g?"paused"===i.state?(m("recording"),g.resume(),t.disableLogs):t.disableLogs:v()}function f(e){postMessage((new FileReaderSync).readAsDataURL(e))}function l(e,i){if(!e)throw"Pass a callback function over getDataURL.";var n=i?i.blob:(g||{}).blob;if(!n)return t.disableLogs,void setTimeout(function(){l(e,i)},1e3);if("undefined"===typeof Worker||navigator.mozGetUserMedia){var o=new FileReader;o.readAsDataURL(n),o.onload=function(t){e(t.target.result)}}else{var a=r(f);a.onmessage=function(t){e(t.data)},a.postMessage(n)}function r(e){try{var t=p.createObjectURL(new Blob([e.toString(),"this.onmessage =  function (eee) {"+e.name+"(eee.data);}"],{type:"application/javascript"})),i=new Worker(t);return p.revokeObjectURL(t),i}catch(e){}}}function h(e){e=e||0,"paused"!==i.state?"stopped"!==i.state&&(e>=i.recordingDuration?a(i.onRecordingStopped):(e+=1e3,setTimeout(function(){h(e)},1e3))):setTimeout(function(){h(e)},1e3)}function m(e){i&&(i.state=e,"function"===typeof i.onStateChanged.call?i.onStateChanged.call(i,e):i.onStateChanged(e))}var g;t.type;function v(){t.disableLogs}var b={startRecording:n,stopRecording:a,pauseRecording:u,resumeRecording:c,initRecorder:o,setRecordingDuration:function(e,t){if("undefined"===typeof e)throw"recordingDuration is required.";if("number"!==typeof e)throw"recordingDuration must be a number.";return i.recordingDuration=e,i.onRecordingStopped=t||function(){},{onRecordingStopped:function(e){i.onRecordingStopped=e}}},clearRecordedData:function(){g?(g.clearRecordedData(),t.disableLogs):v()},getBlob:function(){if(g)return g.blob;v()},getDataURL:l,toURL:function(){if(g)return p.createObjectURL(g.blob);v()},getInternalRecorder:function(){return g},save:function(e){g?k(g.blob,e):v()},getFromDisk:function(e){g?r.getFromDisk(t.type,e):v()},setAdvertisementArray:function(e){t.advertisement=[];for(var i=e.length,n=0;n<i;n++)t.advertisement.push({duration:n,image:e[n]})},blob:null,bufferSize:0,sampleRate:0,buffer:null,reset:function(){"recording"===i.state&&t.disableLogs,g&&"function"===typeof g.clearRecordedData&&g.clearRecordedData(),g=null,m("inactive"),i.blob=null},onStateChanged:function(e){t.disableLogs},state:"inactive",getState:function(){return i.state},destroy:function(){var e=t.disableLogs;t={disableLogs:!0},i.reset(),m("destroyed"),b=i=null,A.AudioContextConstructor&&(A.AudioContextConstructor.close(),A.AudioContextConstructor=null),t.disableLogs=e,t.disableLogs},version:"5.6.1"};if(!this)return i=b,b;for(var w in b)this[w]=b[w];return i=this,b}
/**
 * {@link RecordRTCConfiguration} is an inner/private helper for {@link RecordRTC}.
 * @summary It configures the 2nd parameter passed over {@link RecordRTC} and returns a valid "config" object.
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://MuazKhan.com|Muaz Khan}
 * @typedef RecordRTCConfiguration
 * @class
 * @example
 * var options = RecordRTCConfiguration(mediaStream, options);
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 * @param {MediaStream} mediaStream - MediaStream object fetched using getUserMedia API or generated using captureStreamUntilEnded or WebAudio API.
 * @param {object} config - {type:"video", disableLogs: true, numberOfAudioChannels: 1, bufferSize: 0, sampleRate: 0, video: HTMLVideoElement, getNativeBlob:true, etc.}
 */
function d(e,t){return t.recorderType||t.type||(t.audio&&t.video?t.type="video":t.audio&&!t.video&&(t.type="audio")),t.recorderType&&!t.type&&(t.recorderType===E||t.recorderType===B||"undefined"!==typeof N&&t.recorderType===N?t.type="video":t.recorderType===F?t.type="gif":t.recorderType===x?t.type="audio":t.recorderType===U&&(T(e,"audio").length&&T(e,"video").length?t.type="video":!T(e,"audio").length&&T(e,"video").length?t.type="video":T(e,"audio").length&&!T(e,"video").length&&(t.type="audio"))),"undefined"!==typeof U&&"undefined"!==typeof MediaRecorder&&"requestData"in MediaRecorder.prototype&&(t.mimeType||(t.mimeType="video/webm"),t.type||(t.type=t.mimeType.split("/")[0]),t.bitsPerSecond),t.type||(t.mimeType&&(t.type=t.mimeType.split("/")[0]),t.type||(t.type="audio")),t}
/**
 * {@link GetRecorderType} is an inner/private helper for {@link RecordRTC}.
 * @summary It returns best recorder-type available for your browser.
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://MuazKhan.com|Muaz Khan}
 * @typedef GetRecorderType
 * @class
 * @example
 * var RecorderType = GetRecorderType(options);
 * var recorder = new RecorderType(options);
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 * @param {MediaStream} mediaStream - MediaStream object fetched using getUserMedia API or generated using captureStreamUntilEnded or WebAudio API.
 * @param {object} config - {type:"video", disableLogs: true, numberOfAudioChannels: 1, bufferSize: 0, sampleRate: 0, video: HTMLVideoElement, etc.}
 */function s(e,t){var i;return(w||g||v)&&(i=x),"undefined"!==typeof MediaRecorder&&"requestData"in MediaRecorder.prototype&&!w&&(i=U),"video"===t.type&&(w||v)&&(i=E,"undefined"!==typeof N&&"undefined"!==typeof ReadableStream&&(i=N)),"gif"===t.type&&(i=F),"canvas"===t.type&&(i=B),D()&&i!==B&&i!==F&&"undefined"!==typeof MediaRecorder&&"requestData"in MediaRecorder.prototype&&(T(e,"video").length||T(e,"audio").length)&&("audio"===t.type?"function"===typeof MediaRecorder.isTypeSupported&&MediaRecorder.isTypeSupported("audio/webm")&&(i=U):"function"===typeof MediaRecorder.isTypeSupported&&MediaRecorder.isTypeSupported("video/webm")&&(i=U)),e instanceof Array&&e.length&&(i=P),t.recorderType&&(i=t.recorderType),!t.disableLogs&&i&&i.name,!i&&y&&(i=U),i}
/**
 * MRecordRTC runs on top of {@link RecordRTC} to bring multiple recordings in a single place, by providing simple API.
 * @summary MRecordRTC stands for "Multiple-RecordRTC".
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://MuazKhan.com|Muaz Khan}
 * @typedef MRecordRTC
 * @class
 * @example
 * var recorder = new MRecordRTC();
 * recorder.addStream(MediaStream);
 * recorder.mediaType = {
 *     audio: true, // or StereoAudioRecorder or MediaStreamRecorder
 *     video: true, // or WhammyRecorder or MediaStreamRecorder or WebAssemblyRecorder or CanvasRecorder
 *     gif: true    // or GifRecorder
 * };
 * // mimeType is optional and should be set only in advance cases.
 * recorder.mimeType = {
 *     audio: 'audio/wav',
 *     video: 'video/webm',
 *     gif:   'image/gif'
 * };
 * recorder.startRecording();
 * @see For further information:
 * @see {@link https://github.com/muaz-khan/RecordRTC/tree/master/MRecordRTC|MRecordRTC Source Code}
 * @param {MediaStream} mediaStream - MediaStream object fetched using getUserMedia API or generated using captureStreamUntilEnded or WebAudio API.
 * @requires {@link RecordRTC}
 */function u(e){this.addStream=function(t){t&&(e=t)},this.mediaType={audio:!0,video:!0},this.startRecording=function(){var t,i=this.mediaType,n=this.mimeType||{audio:null,video:null,gif:null};if("function"!==typeof i.audio&&D()&&!T(e,"audio").length&&(i.audio=!1),"function"!==typeof i.video&&D()&&!T(e,"video").length&&(i.video=!1),"function"!==typeof i.gif&&D()&&!T(e,"video").length&&(i.gif=!1),!i.audio&&!i.video&&!i.gif)throw"MediaStream must have either audio or video tracks.";if(i.audio&&(t=null,"function"===typeof i.audio&&(t=i.audio),this.audioRecorder=new r(e,{type:"audio",bufferSize:this.bufferSize,sampleRate:this.sampleRate,numberOfAudioChannels:this.numberOfAudioChannels||2,disableLogs:this.disableLogs,recorderType:t,mimeType:n.audio,timeSlice:this.timeSlice,onTimeStamp:this.onTimeStamp}),i.video||this.audioRecorder.startRecording()),i.video){t=null,"function"===typeof i.video&&(t=i.video);var o=e;if(D()&&i.audio&&"function"===typeof i.audio){var a=T(e,"video")[0];b?(o=new R,o.addTrack(a),t&&t===E&&(t=U)):(o=new R,o.addTrack(a))}this.videoRecorder=new r(o,{type:"video",video:this.video,canvas:this.canvas,frameInterval:this.frameInterval||10,disableLogs:this.disableLogs,recorderType:t,mimeType:n.video,timeSlice:this.timeSlice,onTimeStamp:this.onTimeStamp,workerPath:this.workerPath,webAssemblyPath:this.webAssemblyPath,frameRate:this.frameRate,bitrate:this.bitrate}),i.audio||this.videoRecorder.startRecording()}if(i.audio&&i.video){var d=this,s=!0===D();i.audio instanceof x&&i.video?s=!1:!0!==i.audio&&!0!==i.video&&i.audio!==i.video&&(s=!1),!0===s?(d.audioRecorder=null,d.videoRecorder.startRecording()):d.videoRecorder.initRecorder(function(){d.audioRecorder.initRecorder(function(){d.videoRecorder.startRecording(),d.audioRecorder.startRecording()})})}i.gif&&(t=null,"function"===typeof i.gif&&(t=i.gif),this.gifRecorder=new r(e,{type:"gif",frameRate:this.frameRate||200,quality:this.quality||10,disableLogs:this.disableLogs,recorderType:t,mimeType:n.gif}),this.gifRecorder.startRecording())},this.stopRecording=function(e){e=e||function(){},this.audioRecorder&&this.audioRecorder.stopRecording(function(t){e(t,"audio")}),this.videoRecorder&&this.videoRecorder.stopRecording(function(t){e(t,"video")}),this.gifRecorder&&this.gifRecorder.stopRecording(function(t){e(t,"gif")})},this.pauseRecording=function(){this.audioRecorder&&this.audioRecorder.pauseRecording(),this.videoRecorder&&this.videoRecorder.pauseRecording(),this.gifRecorder&&this.gifRecorder.pauseRecording()},this.resumeRecording=function(){this.audioRecorder&&this.audioRecorder.resumeRecording(),this.videoRecorder&&this.videoRecorder.resumeRecording(),this.gifRecorder&&this.gifRecorder.resumeRecording()},this.getBlob=function(e){var t={};return this.audioRecorder&&(t.audio=this.audioRecorder.getBlob()),this.videoRecorder&&(t.video=this.videoRecorder.getBlob()),this.gifRecorder&&(t.gif=this.gifRecorder.getBlob()),e&&e(t),t},this.destroy=function(){this.audioRecorder&&(this.audioRecorder.destroy(),this.audioRecorder=null),this.videoRecorder&&(this.videoRecorder.destroy(),this.videoRecorder=null),this.gifRecorder&&(this.gifRecorder.destroy(),this.gifRecorder=null)},this.getDataURL=function(e){function t(e,t){if("undefined"!==typeof Worker){var n=i(function(e){postMessage((new FileReaderSync).readAsDataURL(e))});n.onmessage=function(e){t(e.data)},n.postMessage(e)}else{var o=new FileReader;o.readAsDataURL(e),o.onload=function(e){t(e.target.result)}}}function i(e){var t,i=p.createObjectURL(new Blob([e.toString(),"this.onmessage =  function (eee) {"+e.name+"(eee.data);}"],{type:"application/javascript"})),n=new Worker(i);if("undefined"!==typeof p)t=p;else{if("undefined"===typeof webkitURL)throw"Neither URL nor webkitURL detected.";t=webkitURL}return t.revokeObjectURL(i),n}this.getBlob(function(i){i.audio&&i.video?t(i.audio,function(n){t(i.video,function(t){e({audio:n,video:t})})}):i.audio?t(i.audio,function(t){e({audio:t})}):i.video&&t(i.video,function(t){e({video:t})})})},this.writeToDisk=function(){r.writeToDisk({audio:this.audioRecorder,video:this.videoRecorder,gif:this.gifRecorder})},this.save=function(e){e=e||{audio:!0,video:!0,gif:!0},e.audio&&this.audioRecorder&&this.audioRecorder.save("string"===typeof e.audio?e.audio:""),e.video&&this.videoRecorder&&this.videoRecorder.save("string"===typeof e.video?e.video:""),e.gif&&this.gifRecorder&&this.gifRecorder.save("string"===typeof e.gif?e.gif:"")}}r.version="5.6.1",e.exports=r,o=[],a=function(){return r}.apply(t,o),void 0===a||(e.exports=a),r.getFromDisk=function(e,t){if(!t)throw"callback is mandatory.";I.Fetch(function(i,n){"all"!==e&&n===e+"Blob"&&t&&t(i),"all"===e&&t&&t(i,n.replace("Blob",""))})},r.writeToDisk=function(e){e=e||{},e.audio&&e.video&&e.gif?e.audio.getDataURL(function(t){e.video.getDataURL(function(i){e.gif.getDataURL(function(e){I.Store({audioBlob:t,videoBlob:i,gifBlob:e})})})}):e.audio&&e.video?e.audio.getDataURL(function(t){e.video.getDataURL(function(e){I.Store({audioBlob:t,videoBlob:e})})}):e.audio&&e.gif?e.audio.getDataURL(function(t){e.gif.getDataURL(function(e){I.Store({audioBlob:t,gifBlob:e})})}):e.video&&e.gif?e.video.getDataURL(function(t){e.gif.getDataURL(function(e){I.Store({videoBlob:t,gifBlob:e})})}):e.audio?e.audio.getDataURL(function(e){I.Store({audioBlob:e})}):e.video?e.video.getDataURL(function(e){I.Store({videoBlob:e})}):e.gif&&e.gif.getDataURL(function(e){I.Store({gifBlob:e})})},u.getFromDisk=r.getFromDisk,u.writeToDisk=r.writeToDisk,"undefined"!==typeof r&&(r.MRecordRTC=u);var c="Fake/5.0 (FakeOS) AppleWebKit/123 (KHTML, like Gecko) Fake/12.3.4567.89 Fake/123.45";(function(e){e&&"undefined"===typeof window&&"undefined"!==typeof i&&(i.navigator={userAgent:c,getUserMedia:function(){}},i.console||(i.console={}),"undefined"!==typeof i.console.log&&"undefined"!==typeof i.console.error||(i.console.error=i.console.log=i.console.log||function(){}),"undefined"===typeof document&&(e.document={documentElement:{appendChild:function(){return""}}},document.createElement=document.captureStream=document.mozCaptureStream=function(){var e={getContext:function(){return e},play:function(){},pause:function(){},drawImage:function(){},toDataURL:function(){return""},style:{}};return e},e.HTMLVideoElement=function(){}),"undefined"===typeof location&&(e.location={protocol:"file:",href:"",hash:""}),"undefined"===typeof screen&&(e.screen={width:0,height:0}),"undefined"===typeof p&&(e.URL={createObjectURL:function(){return""},revokeObjectURL:function(){return""}}),e.window=i)})("undefined"!==typeof i?i:null);var f=window.requestAnimationFrame;if("undefined"===typeof f)if("undefined"!==typeof webkitRequestAnimationFrame)f=webkitRequestAnimationFrame;else if("undefined"!==typeof mozRequestAnimationFrame)f=mozRequestAnimationFrame;else if("undefined"!==typeof msRequestAnimationFrame)f=msRequestAnimationFrame;else if("undefined"===typeof f){var l=0;f=function(e,t){var i=(new Date).getTime(),n=Math.max(0,16-(i-l)),o=setTimeout(function(){e(i+n)},n);return l=i+n,o}}var h=window.cancelAnimationFrame;"undefined"===typeof h&&("undefined"!==typeof webkitCancelAnimationFrame?h=webkitCancelAnimationFrame:"undefined"!==typeof mozCancelAnimationFrame?h=mozCancelAnimationFrame:"undefined"!==typeof msCancelAnimationFrame?h=msCancelAnimationFrame:"undefined"===typeof h&&(h=function(e){clearTimeout(e)}));var m=window.AudioContext;"undefined"===typeof m&&("undefined"!==typeof webkitAudioContext&&(m=webkitAudioContext),"undefined"!==typeof mozAudioContext&&(m=mozAudioContext));var p=window.URL;"undefined"===typeof p&&"undefined"!==typeof webkitURL&&(p=webkitURL),"undefined"!==typeof navigator&&"undefined"===typeof navigator.getUserMedia&&("undefined"!==typeof navigator.webkitGetUserMedia&&(navigator.getUserMedia=navigator.webkitGetUserMedia),"undefined"!==typeof navigator.mozGetUserMedia&&(navigator.getUserMedia=navigator.mozGetUserMedia));var g=-1!==navigator.userAgent.indexOf("Edge")&&(!!navigator.msSaveBlob||!!navigator.msSaveOrOpenBlob),v=!!window.opera||-1!==navigator.userAgent.indexOf("OPR/"),b=navigator.userAgent.toLowerCase().indexOf("firefox")>-1&&"netscape"in window&&/ rv:/.test(navigator.userAgent),w=!v&&!g&&!!navigator.webkitGetUserMedia||C()||-1!==navigator.userAgent.toLowerCase().indexOf("chrome/"),y=/^((?!chrome|android).)*safari/i.test(navigator.userAgent);y&&!w&&-1!==navigator.userAgent.indexOf("CriOS")&&(y=!1,w=!0);var R=window.MediaStream;function S(e){var t=1e3,i=["Bytes","KB","MB","GB","TB"];if(0===e)return"0 Bytes";var n=parseInt(Math.floor(Math.log(e)/Math.log(t)),10);return(e/Math.pow(t,n)).toPrecision(3)+" "+i[n]}function k(e,t){if(!e)throw"Blob object is required.";if(!e.type)try{e.type="video/webm"}catch(e){}var i=(e.type||"video/webm").split("/")[1];if(t&&-1!==t.indexOf(".")){var n=t.split(".");t=n[0],i=n[1]}var o=(t||Math.round(9999999999*Math.random())+888888888)+"."+i;if("undefined"!==typeof navigator.msSaveOrOpenBlob)return navigator.msSaveOrOpenBlob(e,o);if("undefined"!==typeof navigator.msSaveBlob)return navigator.msSaveBlob(e,o);var a=document.createElement("a");a.href=p.createObjectURL(e),a.download=o,a.style="display:none;opacity:0;color:transparent;",(document.body||document.documentElement).appendChild(a),"function"===typeof a.click?a.click():(a.target="_blank",a.dispatchEvent(new MouseEvent("click",{view:window,bubbles:!0,cancelable:!0}))),p.revokeObjectURL(a.href)}function C(){return"undefined"!==typeof window&&"object"===typeof window.process&&"renderer"===window.process.type||(!("undefined"===typeof n||"object"!==typeof n.versions||!n.versions.electron)||"object"===typeof navigator&&"string"===typeof navigator.userAgent&&navigator.userAgent.indexOf("Electron")>=0)}function T(e,t){return e&&e.getTracks?e.getTracks().filter(function(e){return e.kind===(t||"audio")}):[]}function L(e,t){"srcObject"in t?t.srcObject=e:"mozSrcObject"in t?t.mozSrcObject=e:t.srcObject=e}function M(e,t){if("undefined"===typeof EBML)throw new Error("Please link: https://www.webrtc-experiment.com/EBML.js");var i=new EBML.Reader,n=new EBML.Decoder,o=EBML.tools,a=new FileReader;a.onload=function(e){var a=n.decode(this.result);a.forEach(function(e){i.read(e)}),i.stop();var r=o.makeMetadataSeekable(i.metadatas,i.duration,i.cues),d=this.result.slice(i.metadataSize),s=new Blob([r,d],{type:"video/webm"});t(s)},a.readAsArrayBuffer(e)}"undefined"===typeof R&&"undefined"!==typeof webkitMediaStream&&(R=webkitMediaStream),"undefined"!==typeof R&&"undefined"===typeof R.prototype.stop&&(R.prototype.stop=function(){this.getTracks().forEach(function(e){e.stop()})}),"undefined"!==typeof r&&(r.invokeSaveAsDialog=k,r.getTracks=T,r.getSeekableBlob=M,r.bytesToSize=S,r.isElectron=C);
/**
 * Storage is a standalone object used by {@link RecordRTC} to store reusable objects e.g. "new AudioContext".
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://MuazKhan.com|Muaz Khan}
 * @example
 * Storage.AudioContext === webkitAudioContext
 * @property {webkitAudioContext} AudioContext - Keeps a reference to AudioContext object.
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 */
var A={};function D(){if(b||y||g)return!0;navigator.appVersion;var e,t,i=navigator.userAgent,n=""+parseFloat(navigator.appVersion),o=parseInt(navigator.appVersion,10);return(w||v)&&(e=i.indexOf("Chrome"),n=i.substring(e+7)),-1!==(t=n.indexOf(";"))&&(n=n.substring(0,t)),-1!==(t=n.indexOf(" "))&&(n=n.substring(0,t)),o=parseInt(""+n,10),isNaN(o)&&(n=""+parseFloat(navigator.appVersion),o=parseInt(navigator.appVersion,10)),o>=49}
/**
 * MediaStreamRecorder is an abstraction layer for {@link https://w3c.github.io/mediacapture-record/MediaRecorder.html|MediaRecorder API}. It is used by {@link RecordRTC} to record MediaStream(s) in both Chrome and Firefox.
 * @summary Runs top over {@link https://w3c.github.io/mediacapture-record/MediaRecorder.html|MediaRecorder API}.
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://github.com/muaz-khan|Muaz Khan}
 * @typedef MediaStreamRecorder
 * @class
 * @example
 * var config = {
 *     mimeType: 'video/webm', // vp8, vp9, h264, mkv, opus/vorbis
 *     audioBitsPerSecond : 256 * 8 * 1024,
 *     videoBitsPerSecond : 256 * 8 * 1024,
 *     bitsPerSecond: 256 * 8 * 1024,  // if this is provided, skip above two
 *     checkForInactiveTracks: true,
 *     timeSlice: 1000, // concatenate intervals based blobs
 *     ondataavailable: function() {} // get intervals based blobs
 * }
 * var recorder = new MediaStreamRecorder(mediaStream, config);
 * recorder.record();
 * recorder.stop(function(blob) {
 *     video.src = URL.createObjectURL(blob);
 *
 *     // or
 *     var blob = recorder.blob;
 * });
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 * @param {MediaStream} mediaStream - MediaStream object fetched using getUserMedia API or generated using captureStreamUntilEnded or WebAudio API.
 * @param {object} config - {disableLogs:true, initCallback: function, mimeType: "video/webm", timeSlice: 1000}
 * @throws Will throw an error if first argument "MediaStream" is missing. Also throws error if "MediaRecorder API" are not supported by the browser.
 */function U(e,t){var i=this;if("undefined"===typeof e)throw'First argument "MediaStream" is required.';if("undefined"===typeof MediaRecorder)throw"Your browser does not support the Media Recorder API. Please try other modules e.g. WhammyRecorder or StereoAudioRecorder.";if(t=t||{mimeType:"video/webm"},"audio"===t.type){var n;if(T(e,"video").length&&T(e,"audio").length)navigator.mozGetUserMedia?(n=new R,n.addTrack(T(e,"audio")[0])):n=new R(T(e,"audio")),e=n;t.mimeType&&-1!==t.mimeType.toString().toLowerCase().indexOf("audio")||(t.mimeType=w?"audio/webm":"audio/ogg"),t.mimeType&&"audio/ogg"!==t.mimeType.toString().toLowerCase()&&navigator.mozGetUserMedia&&(t.mimeType="audio/ogg")}var o,a=[];function r(){i.timestamps.push((new Date).getTime()),"function"===typeof t.onTimeStamp&&t.onTimeStamp(i.timestamps[i.timestamps.length-1],i.timestamps)}function d(e){return o&&o.mimeType?o.mimeType:e.mimeType||"video/webm"}function s(){a=[],o=null,i.timestamps=[]}function u(){if("active"in e){if(!e.active)return!1}else if("ended"in e&&e.ended)return!1;return!0}this.getArrayOfBlobs=function(){return a},this.record=function(){i.blob=null,i.clearRecordedData(),i.timestamps=[],c=[],a=[];var n=t;t.disableLogs,o&&(o=null),w&&!D()&&(n="video/vp8"),"function"===typeof MediaRecorder.isTypeSupported&&n.mimeType&&(MediaRecorder.isTypeSupported(n.mimeType)||(t.disableLogs,n.mimeType="audio"===t.type?"audio/webm":"video/webm"));try{o=new MediaRecorder(e,n),t.mimeType=n.mimeType}catch(t){o=new MediaRecorder(e)}n.mimeType&&!MediaRecorder.isTypeSupported&&"canRecordMimeType"in o&&!1===o.canRecordMimeType(n.mimeType)&&t.disableLogs,o.ondataavailable=function(e){if(e.data&&c.push("ondataavailable: "+S(e.data.size)),"number"!==typeof t.timeSlice)!e.data||!e.data.size||e.data.size<100||i.blob?i.recordingCallback&&(i.recordingCallback(new Blob([],{type:d(n)})),i.recordingCallback=null):(i.blob=t.getNativeBlob?e.data:new Blob([e.data],{type:d(n)}),i.recordingCallback&&(i.recordingCallback(i.blob),i.recordingCallback=null));else if(e.data&&e.data.size&&e.data.size>100&&(a.push(e.data),r(),"function"===typeof t.ondataavailable)){var o=t.getNativeBlob?e.data:new Blob([e.data],{type:d(n)});t.ondataavailable(o)}},o.onstart=function(){c.push("started")},o.onpause=function(){c.push("paused")},o.onresume=function(){c.push("resumed")},o.onstop=function(){c.push("stopped")},o.onerror=function(e){e&&(e.name||(e.name="UnknownError"),c.push("error: "+e),t.disableLogs||-1!==e.name.toString().toLowerCase().indexOf("invalidstate")||-1!==e.name.toString().toLowerCase().indexOf("notsupported")||-1!==e.name.toString().toLowerCase().indexOf("security")||"OutOfMemory"===e.name||"IllegalStreamModification"===e.name||"OtherRecordingError"===e.name||e.name,function(e){if(!i.manuallyStopped&&o&&"inactive"===o.state)return delete t.timeslice,void o.start(6e5);setTimeout(e,1e3)}(),"inactive"!==o.state&&"stopped"!==o.state&&o.stop())},"number"===typeof t.timeSlice?(r(),o.start(t.timeSlice)):o.start(36e5),t.initCallback&&t.initCallback()},this.timestamps=[],this.stop=function(e){e=e||function(){},i.manuallyStopped=!0,o&&(this.recordingCallback=e,"recording"===o.state&&o.stop(),"number"===typeof t.timeSlice&&setTimeout(function(){i.blob=new Blob(a,{type:d(t)}),i.recordingCallback(i.blob)},100))},this.pause=function(){o&&"recording"===o.state&&o.pause()},this.resume=function(){o&&"paused"===o.state&&o.resume()},this.clearRecordedData=function(){o&&"recording"===o.state&&i.stop(s),s()},this.getInternalRecorder=function(){return o},this.blob=null,this.getState=function(){return o&&o.state||"inactive"};var c=[];this.getAllStates=function(){return c},"undefined"===typeof t.checkForInactiveTracks&&(t.checkForInactiveTracks=!1);i=this;(function e(){if(o&&!1!==t.checkForInactiveTracks)return!1===u()?(t.disableLogs,void i.stop()):void setTimeout(e,1e3)})(),this.name="MediaStreamRecorder",this.toString=function(){return this.name}}
/**
 * StereoAudioRecorder is a standalone class used by {@link RecordRTC} to bring "stereo" audio-recording in chrome.
 * @summary JavaScript standalone object for stereo audio recording.
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://MuazKhan.com|Muaz Khan}
 * @typedef StereoAudioRecorder
 * @class
 * @example
 * var recorder = new StereoAudioRecorder(MediaStream, {
 *     sampleRate: 44100,
 *     bufferSize: 4096
 * });
 * recorder.record();
 * recorder.stop(function(blob) {
 *     video.src = URL.createObjectURL(blob);
 * });
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 * @param {MediaStream} mediaStream - MediaStream object fetched using getUserMedia API or generated using captureStreamUntilEnded or WebAudio API.
 * @param {object} config - {sampleRate: 44100, bufferSize: 4096, numberOfAudioChannels: 1, etc.}
 */
function x(e,t){if(!T(e,"audio").length)throw"Your stream has no audio tracks.";t=t||{};var i,n=this,o=[],a=[],d=!1,s=0,u=2,c=t.desiredSampRate;function f(){if(!1===t.checkForInactiveTracks)return!0;if("active"in e){if(!e.active)return!1}else if("ended"in e&&e.ended)return!1;return!0}function l(e,t){function i(e,t){var i,n=e.numberOfAudioChannels,o=e.leftBuffers.slice(0),a=e.rightBuffers.slice(0),r=e.sampleRate,d=e.internalInterleavedLength,s=e.desiredSampRate;function u(e,t,i){var n=Math.round(e.length*(t/i)),o=[],a=Number((e.length-1)/(n-1));o[0]=e[0];for(var r=1;r<n-1;r++){var d=r*a,s=Number(Math.floor(d)).toFixed(),u=Number(Math.ceil(d)).toFixed(),f=d-s;o[r]=c(e[s],e[u],f)}return o[n-1]=e[e.length-1],o}function c(e,t,i){return e+(t-e)*i}function f(e,t){for(var i=new Float64Array(t),n=0,o=e.length,a=0;a<o;a++){var r=e[a];i.set(r,n),n+=r.length}return i}function l(e,t){for(var i=e.length+t.length,n=new Float64Array(i),o=0,a=0;a<i;)n[a++]=e[o],n[a++]=t[o],o++;return n}function h(e,t,i){for(var n=i.length,o=0;o<n;o++)e.setUint8(t+o,i.charCodeAt(o))}2===n&&(o=f(o,d),a=f(a,d),s&&(o=u(o,s,r),a=u(a,s,r))),1===n&&(o=f(o,d),s&&(o=u(o,s,r))),s&&(r=s),2===n&&(i=l(o,a)),1===n&&(i=o);var m=i.length,p=44+2*m,g=new ArrayBuffer(p),v=new DataView(g);h(v,0,"RIFF"),v.setUint32(4,36+2*m,!0),h(v,8,"WAVE"),h(v,12,"fmt "),v.setUint32(16,16,!0),v.setUint16(20,1,!0),v.setUint16(22,n,!0),v.setUint32(24,r,!0),v.setUint32(28,2*r,!0),v.setUint16(32,2*n,!0),v.setUint16(34,16,!0),h(v,36,"data"),v.setUint32(40,2*m,!0);for(var b=m,w=44,y=1,R=0;R<b;R++)v.setInt16(w,i[R]*(32767*y),!0),w+=2;if(t)return t({buffer:g,view:v});postMessage({buffer:g,view:v})}if(e.noWorker)i(e,function(e){t(e.buffer,e.view)});else{var n=h(i);n.onmessage=function(e){t(e.data.buffer,e.data.view),p.revokeObjectURL(n.workerURL),n.terminate()},n.postMessage(e)}}function h(e){var t=p.createObjectURL(new Blob([e.toString(),";this.onmessage =  function (eee) {"+e.name+"(eee.data);}"],{type:"application/javascript"})),i=new Worker(t);return i.workerURL=t,i}!0===t.leftChannel&&(u=1),1===t.numberOfAudioChannels&&(u=1),(!u||u<1)&&(u=2),t.disableLogs,"undefined"===typeof t.checkForInactiveTracks&&(t.checkForInactiveTracks=!0),this.record=function(){if(!1===f())throw"Please make sure MediaStream is active.";R(),k=y=!1,d=!0,"undefined"!==typeof t.timeSlice&&M()},this.stop=function(e){e=e||function(){},d=!1,l({desiredSampRate:c,sampleRate:w,numberOfAudioChannels:u,internalInterleavedLength:s,leftBuffers:o,rightBuffers:1===u?[]:a,noWorker:t.noWorker},function(t,i){n.blob=new Blob([i],{type:"audio/wav"}),n.buffer=new ArrayBuffer(i.buffer.byteLength),n.view=i,n.sampleRate=c||w,n.bufferSize=b,n.length=s,k=!1,e&&e(n.blob)})},"undefined"===typeof r.Storage&&(r.Storage={AudioContextConstructor:null,AudioContext:window.AudioContext||window.webkitAudioContext}),r.Storage.AudioContextConstructor&&"closed"!==r.Storage.AudioContextConstructor.state||(r.Storage.AudioContextConstructor=new r.Storage.AudioContext);var m=r.Storage.AudioContextConstructor,g=m.createMediaStreamSource(e),v=[0,256,512,1024,2048,4096,8192,16384],b="undefined"===typeof t.bufferSize?4096:t.bufferSize;if(-1===v.indexOf(b)&&t.disableLogs,m.createJavaScriptNode)i=m.createJavaScriptNode(b,u,u);else{if(!m.createScriptProcessor)throw"WebAudio API has no support on this browser.";i=m.createScriptProcessor(b,u,u)}g.connect(i),t.bufferSize||(b=i.bufferSize);var w="undefined"!==typeof t.sampleRate?t.sampleRate:m.sampleRate||44100;(w<22050||w>96e3)&&t.disableLogs,t.disableLogs||t.desiredSampRate;var y=!1;function R(){o=[],a=[],s=0,k=!1,d=!1,y=!1,m=null,n.leftchannel=o,n.rightchannel=a,n.numberOfAudioChannels=u,n.desiredSampRate=c,n.sampleRate=w,n.recordingLength=s,L={left:[],right:[],recordingLength:0}}function S(){i&&(i.onaudioprocess=null,i.disconnect(),i=null),g&&(g.disconnect(),g=null),R()}this.pause=function(){y=!0},this.resume=function(){if(!1===f())throw"Please make sure MediaStream is active.";if(!d)return t.disableLogs,void this.record();y=!1},this.clearRecordedData=function(){t.checkForInactiveTracks=!1,d&&this.stop(S),S()},this.name="StereoAudioRecorder",this.toString=function(){return this.name};var k=!1;function C(e){if(!y)if(!1===f()&&(t.disableLogs,i.disconnect(),d=!1),d){k||(k=!0,t.onAudioProcessStarted&&t.onAudioProcessStarted(),t.initCallback&&t.initCallback());var r=e.inputBuffer.getChannelData(0),c=new Float32Array(r);if(o.push(c),2===u){var l=e.inputBuffer.getChannelData(1),h=new Float32Array(l);a.push(h)}s+=b,n.recordingLength=s,"undefined"!==typeof t.timeSlice&&(L.recordingLength+=b,L.left.push(c),2===u&&L.right.push(h))}else g&&(g.disconnect(),g=null)}i.onaudioprocess=C,m.createMediaStreamDestination?i.connect(m.createMediaStreamDestination()):i.connect(m.destination),this.leftchannel=o,this.rightchannel=a,this.numberOfAudioChannels=u,this.desiredSampRate=c,this.sampleRate=w,n.recordingLength=s;var L={left:[],right:[],recordingLength:0};function M(){d&&"function"===typeof t.ondataavailable&&"undefined"!==typeof t.timeSlice&&(L.left.length?(l({desiredSampRate:c,sampleRate:w,numberOfAudioChannels:u,internalInterleavedLength:L.recordingLength,leftBuffers:L.left,rightBuffers:1===u?[]:L.right},function(e,i){var n=new Blob([i],{type:"audio/wav"});t.ondataavailable(n),setTimeout(M,t.timeSlice)}),L={left:[],right:[],recordingLength:0}):setTimeout(M,t.timeSlice))}}
/**
 * CanvasRecorder is a standalone class used by {@link RecordRTC} to bring HTML5-Canvas recording into video WebM. It uses HTML2Canvas library and runs top over {@link Whammy}.
 * @summary HTML2Canvas recording into video WebM.
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://MuazKhan.com|Muaz Khan}
 * @typedef CanvasRecorder
 * @class
 * @example
 * var recorder = new CanvasRecorder(htmlElement, { disableLogs: true, useWhammyRecorder: true });
 * recorder.record();
 * recorder.stop(function(blob) {
 *     video.src = URL.createObjectURL(blob);
 * });
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 * @param {HTMLElement} htmlElement - querySelector/getElementById/getElementsByTagName[0]/etc.
 * @param {object} config - {disableLogs:true, initCallback: function}
 */
function B(e,t){if("undefined"===typeof html2canvas)throw"Please link: https://www.webrtc-experiment.com/screenshot.js";t=t||{},t.frameInterval||(t.frameInterval=10);var i=!1;["captureStream","mozCaptureStream","webkitCaptureStream"].forEach(function(e){e in document.createElement("canvas")&&(i=!0)});var n,o,a,r=(!!window.webkitRTCPeerConnection||!!window.webkitGetUserMedia)&&!!window.chrome,d=50,s=navigator.userAgent.match(/Chrom(e|ium)\/([0-9]+)\./);if(r&&s&&s[2]&&(d=parseInt(s[2],10)),r&&d<52&&(i=!1),t.useWhammyRecorder&&(i=!1),i)if(t.disableLogs,e instanceof HTMLCanvasElement)n=e;else{if(!(e instanceof CanvasRenderingContext2D))throw"Please pass either HTMLCanvasElement or CanvasRenderingContext2D.";n=e.canvas}else navigator.mozGetUserMedia&&t.disableLogs;this.record=function(){if(a=!0,i&&!t.useWhammyRecorder){var e;"captureStream"in n?e=n.captureStream(25):"mozCaptureStream"in n?e=n.mozCaptureStream(25):"webkitCaptureStream"in n&&(e=n.webkitCaptureStream(25));try{var r=new R;r.addTrack(T(e,"video")[0]),e=r}catch(e){}if(!e)throw"captureStream API are NOT available.";o=new U(e,{mimeType:t.mimeType||"video/webm"}),o.record()}else m.frames=[],h=(new Date).getTime(),l();t.initCallback&&t.initCallback()},this.getWebPImages=function(i){if("canvas"===e.nodeName.toLowerCase()){var n=m.frames.length;m.frames.forEach(function(e,i){var o=n-i;t.disableLogs,t.onEncodingCallback&&t.onEncodingCallback(o,n);var a=e.image.toDataURL("image/webp",1);m.frames[i].image=a}),t.disableLogs,i()}else i()},this.stop=function(e){a=!1;var n=this;i&&o?o.stop(e):this.getWebPImages(function(){m.compile(function(i){t.disableLogs,n.blob=i,n.blob.forEach&&(n.blob=new Blob([],{type:"video/webm"})),e&&e(n.blob),m.frames=[]})})};var u=!1;function c(){m.frames=[],a=!1,u=!1}function f(){var t=document.createElement("canvas"),i=t.getContext("2d");return t.width=e.width,t.height=e.height,i.drawImage(e,0,0),t}function l(){if(u)return h=(new Date).getTime(),setTimeout(l,500);if("canvas"===e.nodeName.toLowerCase()){var i=(new Date).getTime()-h;return h=(new Date).getTime(),m.frames.push({image:f(),duration:i}),void(a&&setTimeout(l,t.frameInterval))}html2canvas(e,{grabMouse:"undefined"===typeof t.showMousePointer||t.showMousePointer,onrendered:function(e){var i=(new Date).getTime()-h;if(!i)return setTimeout(l,t.frameInterval);h=(new Date).getTime(),m.frames.push({image:e.toDataURL("image/webp",1),duration:i}),a&&setTimeout(l,t.frameInterval)}})}this.pause=function(){u=!0,o instanceof U&&o.pause()},this.resume=function(){u=!1,o instanceof U?o.resume():a||this.record()},this.clearRecordedData=function(){a&&this.stop(c),c()},this.name="CanvasRecorder",this.toString=function(){return this.name};var h=(new Date).getTime(),m=new O.Video(100)}
/**
 * WhammyRecorder is a standalone class used by {@link RecordRTC} to bring video recording in Chrome. It runs top over {@link Whammy}.
 * @summary Video recording feature in Chrome.
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://MuazKhan.com|Muaz Khan}
 * @typedef WhammyRecorder
 * @class
 * @example
 * var recorder = new WhammyRecorder(mediaStream);
 * recorder.record();
 * recorder.stop(function(blob) {
 *     video.src = URL.createObjectURL(blob);
 * });
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 * @param {MediaStream} mediaStream - MediaStream object fetched using getUserMedia API or generated using captureStreamUntilEnded or WebAudio API.
 * @param {object} config - {disableLogs: true, initCallback: function, video: HTMLVideoElement, etc.}
 */
function E(e,t){function i(e){e="undefined"!==typeof e?e:10;var t=(new Date).getTime()-u;return t?r?(u=(new Date).getTime(),setTimeout(i,100)):(u=(new Date).getTime(),s.paused&&s.play(),l.drawImage(s,0,0,f.width,f.height),c.frames.push({duration:t,image:f.toDataURL("image/webp")}),void(a||setTimeout(i,e,e))):setTimeout(i,e,e)}function n(e){var t=-1,i=e.length;(function n(){t++,t!==i?setTimeout(function(){e.functionToLoop(n,t)},1):e.callback()})()}function o(e,t,i,o,a){var r=document.createElement("canvas");r.width=f.width,r.height=f.height;var d=r.getContext("2d"),s=[],u=-1===t,c=t&&t>0&&t<=e.length?t:e.length,l={r:0,g:0,b:0},h=Math.sqrt(Math.pow(255,2)+Math.pow(255,2)+Math.pow(255,2)),m=i&&i>=0&&i<=1?i:0,p=o&&o>=0&&o<=1?o:0,g=!1;n({length:c,functionToLoop:function(t,i){var n,o,a,r=function(){!g&&a-n<=a*p||(u&&(g=!0),s.push(e[i])),t()};if(g)r();else{var c=new Image;c.onload=function(){d.drawImage(c,0,0,f.width,f.height);var e=d.getImageData(0,0,f.width,f.height);n=0,o=e.data.length,a=e.data.length/4;for(var t=0;t<o;t+=4){var i={r:e.data[t],g:e.data[t+1],b:e.data[t+2]},s=Math.sqrt(Math.pow(i.r-l.r,2)+Math.pow(i.g-l.g,2)+Math.pow(i.b-l.b,2));s<=h*m&&n++}r()},c.src=e[i].image}},callback:function(){s=s.concat(e.slice(c)),s.length<=0&&s.push(e[e.length-1]),a(s)}})}t=t||{},t.frameInterval||(t.frameInterval=10),t.disableLogs,this.record=function(){t.width||(t.width=320),t.height||(t.height=240),t.video||(t.video={width:t.width,height:t.height}),t.canvas||(t.canvas={width:t.width,height:t.height}),f.width=t.canvas.width||320,f.height=t.canvas.height||240,l=f.getContext("2d"),t.video&&t.video instanceof HTMLVideoElement?(s=t.video.cloneNode(),t.initCallback&&t.initCallback()):(s=document.createElement("video"),L(e,s),s.onloadedmetadata=function(){t.initCallback&&t.initCallback()},s.width=t.video.width,s.height=t.video.height),s.muted=!0,s.play(),u=(new Date).getTime(),c=new O.Video,t.disableLogs,i(t.frameInterval)};var a=!1;this.stop=function(e){e=e||function(){},a=!0;var i=this;setTimeout(function(){o(c.frames,-1,null,null,function(n){c.frames=n,t.advertisement&&t.advertisement.length&&(c.frames=t.advertisement.concat(c.frames)),c.compile(function(t){i.blob=t,i.blob.forEach&&(i.blob=new Blob([],{type:"video/webm"})),e&&e(i.blob)})})},10)};var r=!1;function d(){c.frames=[],a=!0,r=!1}this.pause=function(){r=!0},this.resume=function(){r=!1,a&&this.record()},this.clearRecordedData=function(){a||this.stop(d),d()},this.name="WhammyRecorder",this.toString=function(){return this.name};var s,u,c,f=document.createElement("canvas"),l=f.getContext("2d")}"undefined"!==typeof m?A.AudioContext=m:"undefined"!==typeof webkitAudioContext&&(A.AudioContext=webkitAudioContext),"undefined"!==typeof r&&(r.Storage=A),"undefined"!==typeof r&&(r.MediaStreamRecorder=U),"undefined"!==typeof r&&(r.StereoAudioRecorder=x),"undefined"!==typeof r&&(r.CanvasRecorder=B),"undefined"!==typeof r&&(r.WhammyRecorder=E);
/**
 * Whammy is a standalone class used by {@link RecordRTC} to bring video recording in Chrome. It is written by {@link https://github.com/antimatter15|antimatter15}
 * @summary A real time javascript webm encoder based on a canvas hack.
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://MuazKhan.com|Muaz Khan}
 * @typedef Whammy
 * @class
 * @example
 * var recorder = new Whammy().Video(15);
 * recorder.add(context || canvas || dataURL);
 * var output = recorder.compile();
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 */
var O=function(){function e(e){this.frames=[],this.duration=e||1,this.quality=.8}function t(e){var t=p.createObjectURL(new Blob([e.toString(),"this.onmessage =  function (eee) {"+e.name+"(eee.data);}"],{type:"application/javascript"})),i=new Worker(t);return p.revokeObjectURL(t),i}function i(e){function t(e){var t=n(e);if(!t)return[];var o=3e4,a=[{id:440786851,data:[{data:1,id:17030},{data:1,id:17143},{data:4,id:17138},{data:8,id:17139},{data:"webm",id:17026},{data:2,id:17031},{data:2,id:17029}]},{id:408125543,data:[{id:357149030,data:[{data:1e6,id:2807729},{data:"whammy",id:19840},{data:"whammy",id:22337},{data:l(t.duration),id:17545}]},{id:374648427,data:[{id:174,data:[{data:1,id:215},{data:1,id:29637},{data:0,id:156},{data:"und",id:2274716},{data:"V_VP8",id:134},{data:"VP8",id:2459272},{data:1,id:131},{id:224,data:[{data:t.width,id:176},{data:t.height,id:186}]}]}]}]}],r=0,s=0;while(r<e.length){var u=[],c=0;do{u.push(e[r]),c+=e[r].duration,r++}while(r<e.length&&c<o);var f=0,h={id:524531317,data:i(s,f,u)};a[1].data.push(h),s+=c}return d(a)}function i(e,t,i){return[{data:e,id:231}].concat(i.map(function(e){var i=s({discardable:0,frame:e.data.slice(4),invisible:0,keyframe:1,lacing:0,trackNum:1,timecode:Math.round(t)});return t+=e.duration,{data:i,id:163}}))}function n(e){if(e[0]){for(var t=e[0].width,i=e[0].height,n=e[0].duration,o=1;o<e.length;o++)n+=e[o].duration;return{duration:n,width:t,height:i}}postMessage({error:"Something went wrong. Maybe WebP format is not supported in the current browser."})}function o(e){var t=[];while(e>0)t.push(255&e),e>>=8;return new Uint8Array(t.reverse())}function a(e){return new Uint8Array(e.split("").map(function(e){return e.charCodeAt(0)}))}function r(e){var t=[],i=e.length%8?new Array(9-e.length%8).join("0"):"";e=i+e;for(var n=0;n<e.length;n+=8)t.push(parseInt(e.substr(n,8),2));return new Uint8Array(t)}function d(e){for(var t=[],i=0;i<e.length;i++){var n=e[i].data;"object"===typeof n&&(n=d(n)),"number"===typeof n&&(n=r(n.toString(2))),"string"===typeof n&&(n=a(n));var s=n.size||n.byteLength||n.length,u=Math.ceil(Math.ceil(Math.log(s)/Math.log(2))/8),c=s.toString(2),f=new Array(7*u+7+1-c.length).join("0")+c,l=new Array(u).join("0")+"1"+f;t.push(o(e[i].id)),t.push(r(l)),t.push(n)}return new Blob(t,{type:"video/webm"})}function s(e){var t=0;if(e.keyframe&&(t|=128),e.invisible&&(t|=8),e.lacing&&(t|=e.lacing<<1),e.discardable&&(t|=1),e.trackNum>127)throw"TrackNumber > 127 not supported";var i=[128|e.trackNum,e.timecode>>8,255&e.timecode,t].map(function(e){return String.fromCharCode(e)}).join("")+e.frame;return i}function u(e){for(var t,i,n,o=e.RIFF[0].WEBP[0],a=o.indexOf("*"),r=0,d=[];r<4;r++)d[r]=o.charCodeAt(a+3+r);return n=d[1]<<8|d[0],t=16383&n,n=d[3]<<8|d[2],i=16383&n,{width:t,height:i,data:o,riff:e}}function c(e,t){return parseInt(e.substr(t+4,4).split("").map(function(e){var t=e.charCodeAt(0).toString(2);return new Array(8-t.length+1).join("0")+t}).join(""),2)}function f(e){var t=0,i={};while(t<e.length){var n=e.substr(t,4),o=c(e,t),a=e.substr(t+4+4,o);t+=8+o,i[n]=i[n]||[],"RIFF"===n||"LIST"===n?i[n].push(f(a)):i[n].push(a)}return i}function l(e){return[].slice.call(new Uint8Array(new Float64Array([e]).buffer),0).map(function(e){return String.fromCharCode(e)}).reverse().join("")}var h=new t(e.map(function(e){var t=u(f(atob(e.image.slice(23))));return t.duration=e.duration,t}));postMessage(h)}return e.prototype.add=function(e,t){if("canvas"in e&&(e=e.canvas),"toDataURL"in e&&(e=e.toDataURL("image/webp",this.quality)),!/^data:image\/webp;base64,/gi.test(e))throw"Input must be formatted properly as a base64 encoded DataURI of type image/webp";this.frames.push({image:e,duration:t||this.duration})},e.prototype.compile=function(e){var n=t(i);n.onmessage=function(t){t.data.error||e(t.data)},n.postMessage(this.frames)},{Video:e}}();"undefined"!==typeof r&&(r.Whammy=O);
/**
 * DiskStorage is a standalone object used by {@link RecordRTC} to store recorded blobs in IndexedDB storage.
 * @summary Writing blobs into IndexedDB.
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://MuazKhan.com|Muaz Khan}
 * @example
 * DiskStorage.Store({
 *     audioBlob: yourAudioBlob,
 *     videoBlob: yourVideoBlob,
 *     gifBlob  : yourGifBlob
 * });
 * DiskStorage.Fetch(function(dataURL, type) {
 *     if(type === 'audioBlob') { }
 *     if(type === 'videoBlob') { }
 *     if(type === 'gifBlob')   { }
 * });
 * // DiskStorage.dataStoreName = 'recordRTC';
 * // DiskStorage.onError = function(error) { };
 * @property {function} init - This method must be called once to initialize IndexedDB ObjectStore. Though, it is auto-used internally.
 * @property {function} Fetch - This method fetches stored blobs from IndexedDB.
 * @property {function} Store - This method stores blobs in IndexedDB.
 * @property {function} onError - This function is invoked for any known/unknown error.
 * @property {string} dataStoreName - Name of the ObjectStore created in IndexedDB storage.
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 */var I={init:function(){var e=this;if("undefined"!==typeof indexedDB&&"undefined"!==typeof indexedDB.open){var t,i=1,n=this.dbName||location.href.replace(/\/|:|#|%|\.|\[|\]/g,""),o=indexedDB.open(n,i);o.onerror=e.onError,o.onsuccess=function(){if(t=o.result,t.onerror=e.onError,t.setVersion)if(t.version!==i){var n=t.setVersion(i);n.onsuccess=function(){a(t),r()}}else r();else r()},o.onupgradeneeded=function(e){a(e.target.result)}}function a(t){t.createObjectStore(e.dataStoreName)}function r(){var i=t.transaction([e.dataStoreName],"readwrite");function n(t){i.objectStore(e.dataStoreName).get(t).onsuccess=function(i){e.callback&&e.callback(i.target.result,t)}}e.videoBlob&&i.objectStore(e.dataStoreName).put(e.videoBlob,"videoBlob"),e.gifBlob&&i.objectStore(e.dataStoreName).put(e.gifBlob,"gifBlob"),e.audioBlob&&i.objectStore(e.dataStoreName).put(e.audioBlob,"audioBlob"),n("audioBlob"),n("videoBlob"),n("gifBlob")}},Fetch:function(e){return this.callback=e,this.init(),this},Store:function(e){return this.audioBlob=e.audioBlob,this.videoBlob=e.videoBlob,this.gifBlob=e.gifBlob,this.init(),this},onError:function(e){},dataStoreName:"recordRTC",dbName:null};
/**
 * GifRecorder is standalone calss used by {@link RecordRTC} to record video or canvas into animated gif.
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://MuazKhan.com|Muaz Khan}
 * @typedef GifRecorder
 * @class
 * @example
 * var recorder = new GifRecorder(mediaStream || canvas || context, { onGifPreview: function, onGifRecordingStarted: function, width: 1280, height: 720, frameRate: 200, quality: 10 });
 * recorder.record();
 * recorder.stop(function(blob) {
 *     img.src = URL.createObjectURL(blob);
 * });
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 * @param {MediaStream} mediaStream - MediaStream object or HTMLCanvasElement or CanvasRenderingContext2D.
 * @param {object} config - {disableLogs:true, initCallback: function, width: 320, height: 240, frameRate: 200, quality: 10}
 */
function F(e,t){if("undefined"===typeof GIFEncoder){var i=document.createElement("script");i.src="https://www.webrtc-experiment.com/gif-recorder.js",(document.body||document.documentElement).appendChild(i)}t=t||{};var n=e instanceof CanvasRenderingContext2D||e instanceof HTMLCanvasElement;this.record=function(){function e(i){if(!0!==p.clearedRecordedData){if(o)return setTimeout(function(){e(i)},100);m=f(e),void 0===typeof c&&(c=i),i-c<90||(!n&&u.paused&&u.play(),n||d.drawImage(u,0,0,r.width,r.height),t.onGifPreview&&t.onGifPreview(r.toDataURL("image/png")),l.addFrame(d),c=i)}}"undefined"!==typeof GIFEncoder&&s?(n||(t.width||(t.width=u.offsetWidth||320),t.height||(t.height=u.offsetHeight||240),t.video||(t.video={width:t.width,height:t.height}),t.canvas||(t.canvas={width:t.width,height:t.height}),r.width=t.canvas.width||320,r.height=t.canvas.height||240,u.width=t.video.width||320,u.height=t.video.height||240),l=new GIFEncoder,l.setRepeat(0),l.setDelay(t.frameRate||200),l.setQuality(t.quality||10),l.start(),"function"===typeof t.onGifRecordingStarted&&t.onGifRecordingStarted(),Date.now(),m=f(e),t.initCallback&&t.initCallback()):setTimeout(p.record,1e3)},this.stop=function(e){e=e||function(){},m&&h(m),Date.now(),this.blob=new Blob([new Uint8Array(l.stream().bin)],{type:"image/gif"}),e(this.blob),l.stream().bin=[]};var o=!1;function a(){l&&(l.stream().bin=[])}this.pause=function(){o=!0},this.resume=function(){o=!1},this.clearRecordedData=function(){p.clearedRecordedData=!0,a()},this.name="GifRecorder",this.toString=function(){return this.name};var r=document.createElement("canvas"),d=r.getContext("2d");n&&(e instanceof CanvasRenderingContext2D?(d=e,r=d.canvas):e instanceof HTMLCanvasElement&&(d=e.getContext("2d"),r=e));var s=!0;if(!n){var u=document.createElement("video");u.muted=!0,u.autoplay=!0,u.playsInline=!0,s=!1,u.onloadedmetadata=function(){s=!0},L(e,u),u.play()}var c,l,m=null,p=this}function j(e,t){var n="Fake/5.0 (FakeOS) AppleWebKit/123 (KHTML, like Gecko) Fake/12.3.4567.89 Fake/123.45";(function(e){"undefined"===typeof r&&e&&"undefined"===typeof window&&"undefined"!==typeof i&&(i.navigator={userAgent:n,getUserMedia:function(){}},i.console||(i.console={}),"undefined"!==typeof i.console.log&&"undefined"!==typeof i.console.error||(i.console.error=i.console.log=i.console.log||function(){}),"undefined"===typeof document&&(e.document={documentElement:{appendChild:function(){return""}}},document.createElement=document.captureStream=document.mozCaptureStream=function(){var e={getContext:function(){return e},play:function(){},pause:function(){},drawImage:function(){},toDataURL:function(){return""},style:{}};return e},e.HTMLVideoElement=function(){}),"undefined"===typeof location&&(e.location={protocol:"file:",href:"",hash:""}),"undefined"===typeof screen&&(e.screen={width:0,height:0}),"undefined"===typeof f&&(e.URL={createObjectURL:function(){return""},revokeObjectURL:function(){return""}}),e.window=i)})("undefined"!==typeof i?i:null),t=t||"multi-streams-mixer";var o=[],a=!1,d=document.createElement("canvas"),s=d.getContext("2d");d.style.opacity=0,d.style.position="absolute",d.style.zIndex=-1,d.style.top="-1000em",d.style.left="-1000em",d.className=t,(document.body||document.documentElement).appendChild(d),this.disableLogs=!1,this.frameInterval=10,this.width=360,this.height=240,this.useGainNode=!0;var u=this,c=window.AudioContext;"undefined"===typeof c&&("undefined"!==typeof webkitAudioContext&&(c=webkitAudioContext),"undefined"!==typeof mozAudioContext&&(c=mozAudioContext));var f=window.URL;"undefined"===typeof f&&"undefined"!==typeof webkitURL&&(f=webkitURL),"undefined"!==typeof navigator&&"undefined"===typeof navigator.getUserMedia&&("undefined"!==typeof navigator.webkitGetUserMedia&&(navigator.getUserMedia=navigator.webkitGetUserMedia),"undefined"!==typeof navigator.mozGetUserMedia&&(navigator.getUserMedia=navigator.mozGetUserMedia));var l=window.MediaStream;"undefined"===typeof l&&"undefined"!==typeof webkitMediaStream&&(l=webkitMediaStream),"undefined"!==typeof l&&"undefined"===typeof l.prototype.stop&&(l.prototype.stop=function(){this.getTracks().forEach(function(e){e.stop()})});var h={};function m(e,t){"srcObject"in t?t.srcObject=e:"mozSrcObject"in t?t.mozSrcObject=e:t.srcObject=e}function p(){if(!a){var e=o.length,t=!1,i=[];if(o.forEach(function(e){e.stream||(e.stream={}),e.stream.fullcanvas?t=e:i.push(e)}),t)d.width=t.stream.width,d.height=t.stream.height;else if(i.length){d.width=e>1?2*i[0].width:i[0].width;var n=1;3!==e&&4!==e||(n=2),5!==e&&6!==e||(n=3),7!==e&&8!==e||(n=4),9!==e&&10!==e||(n=5),d.height=i[0].height*n}else d.width=u.width||360,d.height=u.height||240;t&&t instanceof HTMLVideoElement&&g(t),i.forEach(function(e,t){g(e,t)}),setTimeout(p,u.frameInterval)}}function g(e,t){if(!a){var i=0,n=0,o=e.width,r=e.height;1===t&&(i=e.width),2===t&&(n=e.height),3===t&&(i=e.width,n=e.height),4===t&&(n=2*e.height),5===t&&(i=e.width,n=2*e.height),6===t&&(n=3*e.height),7===t&&(i=e.width,n=3*e.height),"undefined"!==typeof e.stream.left&&(i=e.stream.left),"undefined"!==typeof e.stream.top&&(n=e.stream.top),"undefined"!==typeof e.stream.width&&(o=e.stream.width),"undefined"!==typeof e.stream.height&&(r=e.stream.height),s.drawImage(e,i,n,o,r),"function"===typeof e.stream.onRender&&e.stream.onRender(s,i,n,o,r,t)}}function v(){a=!1;var t=b(),i=w();return i&&i.getTracks().filter(function(e){return"audio"===e.kind}).forEach(function(e){t.addTrack(e)}),e.forEach(function(e){e.fullcanvas&&!0}),t}function b(){var e;R(),"captureStream"in d?e=d.captureStream():"mozCaptureStream"in d?e=d.mozCaptureStream():u.disableLogs;var t=new l;return e.getTracks().filter(function(e){return"video"===e.kind}).forEach(function(e){t.addTrack(e)}),d.stream=t,t}function w(){h.AudioContextConstructor||(h.AudioContextConstructor=new h.AudioContext),u.audioContext=h.AudioContextConstructor,u.audioSources=[],!0===u.useGainNode&&(u.gainNode=u.audioContext.createGain(),u.gainNode.connect(u.audioContext.destination),u.gainNode.gain.value=0);var t=0;if(e.forEach(function(e){if(e.getTracks().filter(function(e){return"audio"===e.kind}).length){t++;var i=u.audioContext.createMediaStreamSource(e);!0===u.useGainNode&&i.connect(u.gainNode),u.audioSources.push(i)}}),t)return u.audioDestination=u.audioContext.createMediaStreamDestination(),u.audioSources.forEach(function(e){e.connect(u.audioDestination)}),u.audioDestination.stream}function y(e){var i=document.createElement("video");return m(e,i),i.className=t,i.muted=!0,i.volume=0,i.width=e.width||u.width||360,i.height=e.height||u.height||240,i.play(),i}function R(t){o=[],t=t||e,t.forEach(function(e){if(e.getTracks().filter(function(e){return"video"===e.kind}).length){var t=y(e);t.stream=e,o.push(t)}})}"undefined"!==typeof c?h.AudioContext=c:"undefined"!==typeof webkitAudioContext&&(h.AudioContext=webkitAudioContext),this.startDrawingFrames=function(){p()},this.appendStreams=function(t){if(!t)throw"First parameter is required.";t instanceof Array||(t=[t]),t.forEach(function(t){var i=new l;if(t.getTracks().filter(function(e){return"video"===e.kind}).length){var n=y(t);n.stream=t,o.push(n),i.addTrack(t.getTracks().filter(function(e){return"video"===e.kind})[0])}if(t.getTracks().filter(function(e){return"audio"===e.kind}).length){var a=u.audioContext.createMediaStreamSource(t);u.audioDestination=u.audioContext.createMediaStreamDestination(),a.connect(u.audioDestination),i.addTrack(u.audioDestination.stream.getTracks().filter(function(e){return"audio"===e.kind})[0])}e.push(i)})},this.releaseStreams=function(){o=[],a=!0,u.gainNode&&(u.gainNode.disconnect(),u.gainNode=null),u.audioSources.length&&(u.audioSources.forEach(function(e){e.disconnect()}),u.audioSources=[]),u.audioDestination&&(u.audioDestination.disconnect(),u.audioDestination=null),u.audioContext&&u.audioContext.close(),u.audioContext=null,s.clearRect(0,0,d.width,d.height),d.stream&&(d.stream.stop(),d.stream=null)},this.resetVideoStreams=function(e){!e||e instanceof Array||(e=[e]),R(e)},this.name="MultiStreamsMixer",this.toString=function(){return this.name},this.getMixedStream=v}
/**
 * MultiStreamRecorder can record multiple videos in single container.
 * @summary Multi-videos recorder.
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://MuazKhan.com|Muaz Khan}
 * @typedef MultiStreamRecorder
 * @class
 * @example
 * var options = {
 *     mimeType: 'video/webm'
 * }
 * var recorder = new MultiStreamRecorder(ArrayOfMediaStreams, options);
 * recorder.record();
 * recorder.stop(function(blob) {
 *     video.src = URL.createObjectURL(blob);
 *
 *     // or
 *     var blob = recorder.blob;
 * });
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 * @param {MediaStreams} mediaStreams - Array of MediaStreams.
 * @param {object} config - {disableLogs:true, frameInterval: 1, mimeType: "video/webm"}
 */
function P(e,t){e=e||[];var i,n,o=this;function a(){var t=[];return e.forEach(function(e){T(e,"video").forEach(function(e){t.push(e)})}),t}t=t||{elementClass:"multi-streams-mixer",mimeType:"video/webm",video:{width:360,height:240}},t.frameInterval||(t.frameInterval=10),t.video||(t.video={}),t.video.width||(t.video.width=360),t.video.height||(t.video.height=240),this.record=function(){i=new j(e,t.elementClass||"multi-streams-mixer"),a().length&&(i.frameInterval=t.frameInterval||10,i.width=t.video.width||360,i.height=t.video.height||240,i.startDrawingFrames()),t.previewStream&&"function"===typeof t.previewStream&&t.previewStream(i.getMixedStream()),n=new U(i.getMixedStream(),t),n.record()},this.stop=function(e){n&&n.stop(function(t){o.blob=t,e(t),o.clearRecordedData()})},this.pause=function(){n&&n.pause()},this.resume=function(){n&&n.resume()},this.clearRecordedData=function(){n&&(n.clearRecordedData(),n=null),i&&(i.releaseStreams(),i=null)},this.addStreams=function(o){if(!o)throw"First parameter is required.";o instanceof Array||(o=[o]),e.concat(o),n&&i&&(i.appendStreams(o),t.previewStream&&"function"===typeof t.previewStream&&t.previewStream(i.getMixedStream()))},this.resetVideoStreams=function(e){i&&(!e||e instanceof Array||(e=[e]),i.resetVideoStreams(e))},this.getMixer=function(){return i},this.name="MultiStreamRecorder",this.toString=function(){return this.name}}
/**
 * RecordRTCPromisesHandler adds promises support in {@link RecordRTC}. Try a {@link https://github.com/muaz-khan/RecordRTC/blob/master/simple-demos/RecordRTCPromisesHandler.html|demo here}
 * @summary Promises for {@link RecordRTC}
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://MuazKhan.com|Muaz Khan}
 * @typedef RecordRTCPromisesHandler
 * @class
 * @example
 * var recorder = new RecordRTCPromisesHandler(mediaStream, options);
 * recorder.startRecording()
 *         .then(successCB)
 *         .catch(errorCB);
 * // Note: You can access all RecordRTC API using "recorder.recordRTC" e.g. 
 * recorder.recordRTC.onStateChanged = function(state) {};
 * recorder.recordRTC.setRecordingDuration(5000);
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 * @param {MediaStream} mediaStream - Single media-stream object, array of media-streams, html-canvas-element, etc.
 * @param {object} config - {type:"video", recorderType: MediaStreamRecorder, disableLogs: true, numberOfAudioChannels: 1, bufferSize: 0, sampleRate: 0, video: HTMLVideoElement, etc.}
 * @throws Will throw an error if "new" keyword is not used to initiate "RecordRTCPromisesHandler". Also throws error if first argument "MediaStream" is missing.
 * @requires {@link RecordRTC}
 */
function z(e,t){if(!this)throw'Use "new RecordRTCPromisesHandler()"';if("undefined"===typeof e)throw'First argument "MediaStream" is required.';var i=this;i.recordRTC=new r(e,t),this.startRecording=function(){return new Promise(function(e,t){try{i.recordRTC.startRecording(),e()}catch(e){t(e)}})},this.stopRecording=function(){return new Promise(function(e,t){try{i.recordRTC.stopRecording(function(n){i.blob=i.recordRTC.getBlob(),i.blob&&i.blob.size?e(n):t("Empty blob.",i.blob)})}catch(e){t(e)}})},this.pauseRecording=function(){return new Promise(function(e,t){try{i.recordRTC.pauseRecording(),e()}catch(e){t(e)}})},this.resumeRecording=function(){return new Promise(function(e,t){try{i.recordRTC.resumeRecording(),e()}catch(e){t(e)}})},this.getDataURL=function(e){return new Promise(function(e,t){try{i.recordRTC.getDataURL(function(t){e(t)})}catch(e){t(e)}})},this.getBlob=function(){return new Promise(function(e,t){try{e(i.recordRTC.getBlob())}catch(e){t(e)}})},this.getInternalRecorder=function(){return new Promise(function(e,t){try{e(i.recordRTC.getInternalRecorder())}catch(e){t(e)}})},this.reset=function(){return new Promise(function(e,t){try{e(i.recordRTC.reset())}catch(e){t(e)}})},this.destroy=function(){return new Promise(function(e,t){try{e(i.recordRTC.destroy())}catch(e){t(e)}})},this.getState=function(){return new Promise(function(e,t){try{e(i.recordRTC.getState())}catch(e){t(e)}})},this.blob=null,this.version="5.6.1"}
/**
 * WebAssemblyRecorder lets you create webm videos in JavaScript via WebAssembly. The library consumes raw RGBA32 buffers (4 bytes per pixel) and turns them into a webm video with the given framerate and quality. This makes it compatible out-of-the-box with ImageData from a CANVAS. With realtime mode you can also use webm-wasm for streaming webm videos.
 * @summary Video recording feature in Chrome, Firefox and maybe Edge.
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://MuazKhan.com|Muaz Khan}
 * @typedef WebAssemblyRecorder
 * @class
 * @example
 * var recorder = new WebAssemblyRecorder(mediaStream);
 * recorder.record();
 * recorder.stop(function(blob) {
 *     video.src = URL.createObjectURL(blob);
 * });
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 * @param {MediaStream} mediaStream - MediaStream object fetched using getUserMedia API or generated using captureStreamUntilEnded or WebAudio API.
 * @param {object} config - {webAssemblyPath:'webm-wasm.wasm',workerPath: 'webm-worker.js', frameRate: 30, width: 1920, height: 1080, bitrate: 1024, realtime: true}
 */
function N(e,t){var i,n,o;function a(){return new ReadableStream({start:function(n){var o=document.createElement("canvas"),a=document.createElement("video"),r=!0;a.srcObject=e,a.muted=!0,a.height=t.height,a.width=t.width,a.volume=0,a.onplaying=function(){o.width=t.width,o.height=t.height;var e=o.getContext("2d"),d=1e3/t.frameRate,s=setInterval(function(){if(i&&(clearInterval(s),n.close()),r&&(r=!1,t.onVideoProcessStarted&&t.onVideoProcessStarted()),e.drawImage(a,0,0),"closed"!==n._controlledReadableStream.state)try{n.enqueue(e.getImageData(0,0,t.width,t.height))}catch(e){}},d)},a.play()}})}function r(e,d){if(!t.workerPath&&!d)return i=!1,void fetch("https://unpkg.com/webm-wasm@latest/dist/webm-worker.js").then(function(t){t.arrayBuffer().then(function(t){r(e,t)})});if(!t.workerPath&&d instanceof ArrayBuffer){var u=new Blob([d],{type:"text/javascript"});t.workerPath=p.createObjectURL(u)}t.workerPath,n=new Worker(t.workerPath),n.postMessage(t.webAssemblyPath||"https://unpkg.com/webm-wasm@latest/dist/webm-wasm.wasm"),n.addEventListener("message",function(e){"READY"===e.data?(n.postMessage({width:t.width,height:t.height,bitrate:t.bitrate||1200,timebaseDen:t.frameRate||30,realtime:t.realtime}),a().pipeTo(new WritableStream({write:function(e){i||n.postMessage(e.data.buffer,[e.data.buffer])}}))):e.data&&(o||s.push(e.data))})}function d(e){n?(n.addEventListener("message",function(t){null===t.data&&(n.terminate(),n=null,e&&e())}),n.postMessage(null)):e&&e()}t=t||{},t.width=t.width||640,t.height=t.height||480,t.frameRate=t.frameRate||30,t.bitrate=t.bitrate||1200,t.realtime=t.realtime||!0,this.record=function(){s=[],o=!1,this.blob=null,r(e),"function"===typeof t.initCallback&&t.initCallback()},this.pause=function(){o=!0},this.resume=function(){o=!1};var s=[];this.stop=function(e){i=!0;var t=this;d(function(){t.blob=new Blob(s,{type:"video/webm"}),e(t.blob)})},this.name="WebAssemblyRecorder",this.toString=function(){return this.name},this.clearRecordedData=function(){s=[],o=!1,this.blob=null},this.blob=null}"undefined"!==typeof r&&(r.DiskStorage=I),"undefined"!==typeof r&&(r.GifRecorder=F),"undefined"===typeof r&&(e.exports=j,o=[],a=function(){return j}.apply(t,o),void 0===a||(e.exports=a)),"undefined"!==typeof r&&(r.MultiStreamRecorder=P),"undefined"!==typeof r&&(r.RecordRTCPromisesHandler=z),"undefined"!==typeof r&&(r.WebAssemblyRecorder=N)}).call(this,i("c8ba"),i("4362"))}}]);